/*
 * UnoUtils.java
 *
 * Created on February 18, 2003, 3:43 PM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.OOoUno;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Type;

/**
 *
 * @author  danny brewer
 */
public class UnoUtils {
	private UnoUtils() { }
	
	
	
	// Print out everything about a UNO service object..
	public static void printService( Object unoService ) {
		// Every service must implement the com.sun.star.lang.XServiceInfo interface.
		XServiceInfo xServiceInfo =
				(XServiceInfo) UnoRuntime.queryInterface( XServiceInfo.class, unoService );
		
		// Show implementation name
		System.out.println( "XServiceInfo.getImplementationName(): " + xServiceInfo.getImplementationName() );
		
		// Show supported service names.
		String[] serviceNames = xServiceInfo.getSupportedServiceNames();
		System.out.print( "XServiceInfo.getSupportedServiceNames()" );
		if( serviceNames.length > 0 ) {
			System.out.println( "..." );
			for( int i = 0;  i < serviceNames.length;  ++i ) {
				System.out.println( "  [" + i + "]  " + serviceNames[i] );
			}
		} else {
			System.out.println( " returns empty list." );
		}
					
		// Every service must implement the com.sun.star.lang.XTypeProvider interface.
		XTypeProvider xTypeProvider =
				(XTypeProvider) UnoRuntime.queryInterface( XTypeProvider.class, unoService );
		
		// Show type names.
		Type[] types = xTypeProvider.getTypes();
		System.out.print( "XTypeProvider.getTypes()" );
		if( types.length > 0 ) {
			System.out.println( "..." );
			for( int i = 0;  i < types.length;  ++i ) {
				System.out.println( "  [" + i + "]  " + types[i].getTypeName() );
			}
		} else {
			System.out.println( " returns empty list." );
		}
	}
	
	
	
}
